﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/

#include "gameFunctions/nestedEval.as"
// run()
define_fadeScreen = function( thisCommand_obj ){
	
	
	if(TRACE_SCRIPT)
		trace("\nFade:  "+thisCommand_obj.data.fadeDir);
	
	// start the transition
	var prom;
	var settings;
	var transition = thisCommand_obj.data.transition;
	if( transition ){
		settings = {effect: transition.effect, seconds: transition.seconds, easing: transition.easing, mask: transition.mask};
	}
	if(thisCommand_obj.data.fadeDir === "out"){
		// out
		if( !transition ){
			// no transition specified  (legacy behavior)
			settings = {effect: "fadeBlack", seconds: 0.5, easing: "easeLinear", mask: ""};
		}
		prom = TRANSITION.start(settings);
	}else{
		// in
		if( !transition ){
			// no transition specified  (legacy behavior)
			settings = {effect: "fade", seconds: 0.5, easing: "easeLinear", mask: ""};
		}
		prom = TRANSITION.doFadeIn(settings);
	}
	
	
	// run next command
	if( thisCommand_obj.data.waitForEnd  &&  prom ){
		// if:  waitForEnd = true  =>  wait for promise
		return prom;
	}else{
		// if:  waitForEnd = false  =>  instantly done
		return VOW.make().keep();		// this intentionally ignores the "prom" that is tied to the transition
	}
	
	
}// define_fadeScreen()